
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1217.C - Message 1217 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1217 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1217.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:00   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:49:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:40   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 14:00:12   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:10   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1217 message from the ZMsgBuf.
//
void Dec1217(tMSGBUF *ZMsgBuf, tMSG1217 *Msg)
{  
   GetBit(&SolValidData.AltNotUsedReq  , ZMsgBuf, 7, 0); // 1=required
   GetBit(&SolValidData.DGPSRequired   , ZMsgBuf, 7, 1); // 1=required
   GetBit(&SolValidData.DRMeasRequired , ZMsgBuf, 7, 2); // 1=required
   GetBit(&SolValidData.ConGPSRequired , ZMsgBuf, 7, 3); // 1=required
   GetBit(&SolValidData.GPSOnlyRequired, ZMsgBuf, 7, 4); // 1=required
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1217 message in the ZMsgBuf. 
//
void Bld1217(tMSGBUF *ZMsgBuf, tMSG1217 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                          , ZMsgBuf, 1);    // message preamble
   PutShort  (1217                            , ZMsgBuf, 2);    // message number
   PutShort  (7                               , ZMsgBuf, 3);    // message length 
   PutShort  (ANREQ                           , ZMsgBuf, 4);    // message ack/nack request
   
   PutBit(SolValidData.AltNotUsedReq  , ZMsgBuf, 7, 0); // 1=required
   PutBit(SolValidData.DGPSRequired   , ZMsgBuf, 7, 1); // 1=required
   PutBit(SolValidData.DRMeasRequired , ZMsgBuf, 7, 2); // 1=required
   PutBit(SolValidData.ConGPSRequired , ZMsgBuf, 7, 3); // 1=required
   PutBit(SolValidData.GPSOnlyRequired, ZMsgBuf, 7, 4); // 1=required
}

